/**
 * @file test_my_math.c
 * @author David TRUAN (david.truan@edgemtech.ch)
 * @brief Simple test example to show how to run some
 * unit tests on a simple module
 *
 * @copyright Copyright (c) 2025 EDGEMTech Ltd.
 *
 */
#include "unity.h"
#include "my_math.h"

void setUp(void) {
}

void tearDown(void) {
}

void test_addition(void) {
    TEST_ASSERT_EQUAL(40, my_add(30, 10));
    TEST_ASSERT_EQUAL(-40, my_add(0, -40));
    TEST_ASSERT_EQUAL(0, my_add(40, -40));
}

void test_substraction(void) {
    TEST_ASSERT_EQUAL(20, my_sub(30, 10));
    TEST_ASSERT_EQUAL(40, my_sub(0, -40));
    TEST_ASSERT_EQUAL(0, my_sub(40, 40));
    TEST_ASSERT_NOT_EQUAL(0, my_sub(40, 30));
}

/* Even if multiple tests are run here, they are all reported as
one test */
int main(void) {
    UNITY_BEGIN();
    RUN_TEST(test_addition);
    RUN_TEST(test_substraction);
    return UNITY_END();
}